/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.saverest;

import com.ibm.hwmca.base.saverest.CustomizableData;
import com.ibm.hwmca.base.saverest.DataRepApp;
import com.ibm.hwmca.base.saverest.SaveRestoreConstants;
import com.ibm.hwmca.base.saverest.SaveRestoreData;
import com.ibm.hwmca.base.saverest.SaveRestoreErrorIds;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.MicrocodeLogAttributes;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.Tower;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockException;
import com.ibm.hwmca.fw.mediasvc.MediaServices;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SaveRestoreUtil
implements SaveRestoreErrorIds,
SaveRestoreConstants {
    private static final String TRACE_MASKT = "XSRDUTLT";
    private static final String TRACE_MASKF = "XSRDUTLF";
    private static final String TRACE_MASKD = "XSRDUTLD";
    private static DataRepApp dataRepApp = DataRepApp.getDataRepApp();
    static final String INTERFACE_NAME = "com.ibm.hwmca.base.saverest.SaveRestoreData";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "SaveRestCustData");
    protected List implList = new ArrayList();
    protected List saveableItems = null;
    protected int numItems;
    protected String[][] rawData;

    public SaveRestoreUtil() {
        ClassId towers = new ClassId("com.ibm.hwmca.fw.managed", "Tower");
        Set inventory = ManagedObjectManager.getManagedObjectManager().getInventory(towers);
        Trace.trace(TRACE_MASKT, "inventory size: " + inventory.size());
        Iterator iterator = inventory.iterator();
        while (iterator.hasNext()) {
            HwmcaObject obj = (HwmcaObject)iterator.next();
            if (!(obj instanceof Tower)) continue;
            Trace.trace(TRACE_MASKT, "found a tower");
            try {
                Object impl = ((Tower)obj).getInterfaceImpl(Class.forName(INTERFACE_NAME));
                if (impl == null) continue;
                Trace.trace(TRACE_MASKT, "adding an impl");
                this.implList.add(impl);
            }
            catch (Exception e) {}
        }
        this.saveableItems = new ArrayList();
        ArrayList<SaveRestoreData> badImpls = new ArrayList<SaveRestoreData>();
        this.numItems = 0;
        Iterator iterator2 = this.implList.iterator();
        while (iterator2.hasNext()) {
            SaveRestoreData implClass = (SaveRestoreData)iterator2.next();
            implClass.prepare();
            CustomizableData[] items = implClass.getSaveableItems();
            if (items == null || items.length == 0) {
                badImpls.add(implClass);
                continue;
            }
            this.saveableItems.add(items);
            this.numItems += items.length;
        }
        iterator2 = badImpls.iterator();
        while (iterator2.hasNext()) {
            Trace.trace(TRACE_MASKT, "Bad impl! Bad impl!");
            SaveRestoreData emptyImpl = (SaveRestoreData)iterator2.next();
            this.implList.remove(emptyImpl);
        }
        badImpls = null;
        Trace.trace(TRACE_MASKT, "We will have " + this.numItems + " entries in the list");
    }

    public String[][] getItemDescriptorRawData() {
        if (this.rawData == null) {
            this.rawData = new String[2][this.numItems];
            int j = 0;
            for (int i = 0; i < this.implList.size(); ++i) {
                CustomizableData[] itemArray = (CustomizableData[])this.saveableItems.get(i);
                for (int k = 0; k < itemArray.length; ++k) {
                    this.rawData[0][j] = String.valueOf(i) + "_" + String.valueOf(k);
                    this.rawData[1][j] = itemArray[k].getUIInfo().getTitle();
                    Trace.trace(TRACE_MASKT, itemArray[k]);
                    ++j;
                }
            }
        }
        return this.rawData;
    }

    void saveItems(String[] selectedStrings, String filename) throws HException {
        Trace.trace(TRACE_MASKT, "-> SaveRestoreUtil.getSaveItems()");
        try {
            HashMap<String, Serializable> saveItems = new HashMap<String, Serializable>();
            for (int i = 0; i < selectedStrings.length; ++i) {
                int underscore = selectedStrings[i].indexOf(95);
                int impl = Integer.parseInt(selectedStrings[i].substring(0, underscore));
                int item = Integer.parseInt(selectedStrings[i].substring(underscore + 1));
                SaveRestoreData implClass = (SaveRestoreData)this.implList.get(impl);
                Serializable obj = implClass.getItem(((CustomizableData[])this.saveableItems.get(impl))[item].getCustomDataKey());
                saveItems.put(((CustomizableData[])this.saveableItems.get(impl))[item].getCustomDataKey(), obj);
            }
            this.saveDataToDisk(filename, saveItems);
        }
        catch (HException he) {
            new FrameworkLog(_logInfo, 2, he).log(MicrocodeLogAttributes.INFO_LOG);
            throw he;
        }
        Trace.trace(TRACE_MASKT, "<- SaveRestoreUtil.getSaveItems()");
    }

    void restoreItems(String[] selectedStrings, String filename) throws HException {
        Trace.trace(TRACE_MASKT, "-> SaveRestoreUtil.restoreItems()");
        try {
            Map map = this.restoreDataFromDisk(filename);
            SaveRestoreData implClass = null;
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                String objId = (String)i.next();
                Serializable obj = (Serializable)map.get(objId);
                boolean found = false;
                for (int j = 0; j < selectedStrings.length; ++j) {
                    int underscore = selectedStrings[j].indexOf(95);
                    int impl = Integer.parseInt(selectedStrings[j].substring(0, underscore));
                    int item = Integer.parseInt(selectedStrings[j].substring(underscore + 1));
                    implClass = (SaveRestoreData)this.implList.get(impl);
                    if (!((CustomizableData[])this.saveableItems.get(impl))[item].getCustomDataKey().equals(objId)) continue;
                    found = true;
                    j = selectedStrings.length;
                }
                if (found) {
                    Trace.trace(TRACE_MASKF, "Found: " + objId + ", " + obj);
                    implClass.setItem(objId, obj);
                    continue;
                }
                Trace.trace(TRACE_MASKF, "Couldn't find: " + objId);
            }
        }
        catch (HException he) {
            new FrameworkLog(_logInfo, 2, he).log(MicrocodeLogAttributes.INFO_LOG);
            throw he;
        }
        Trace.trace(TRACE_MASKT, "<- SaveRestoreUtil.restoreItems()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveDataToDisk(String filename, Map map) throws HException {
        Trace.trace(TRACE_MASKT, "<> SaveRestoreUtil.saveDataToDisk");
        MediaServices mediaServices = null;
        MediaDeviceIdentifier mediaDeviceIdentifier = null;
        MediaDevice mediaDevice = null;
        try {
            try {
                mediaServices = MediaServices.getMediaServices();
                Trace.trace(TRACE_MASKF, "got media services");
                mediaDeviceIdentifier = mediaServices.queryMediaDevicePath(filename);
                Trace.trace(TRACE_MASKF, "got media deviceIdentifier: " + mediaDeviceIdentifier);
                if (mediaDeviceIdentifier != null) {
                    Trace.trace(TRACE_MASKF, "requesting media lock");
                    mediaDevice = mediaServices.requestLock(new LocalizableText("SaveRestoreUtil"), mediaDeviceIdentifier);
                    Trace.trace(TRACE_MASKF, "mounting");
                    mediaDevice.mountReadWrite();
                }
                Trace.trace(TRACE_MASKF, "writing out file");
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(new File(filename)));
                oos.writeObject(map);
                oos.flush();
                oos.close();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                }
                Object var9_11 = null;
                if (mediaDevice == null) return;
            }
            catch (MediaDeviceLockException mdle) {
                Trace.trace(TRACE_MASKF, "MediaDeviceLockException");
                Trace.trace(TRACE_MASKF, mdle);
                throw new HException(mdle);
            }
            catch (MediaDeviceException mde) {
                Trace.trace(TRACE_MASKF, "MediaDeviceException");
                Trace.trace(TRACE_MASKF, mde);
                throw new HException(mde);
            }
            catch (IOException ioe) {
                Trace.trace(TRACE_MASKF, ioe);
                throw new HException(ioe);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (mediaDevice == null) throw throwable;
            try {
                mediaDevice.unmount();
                mediaDevice.unlock();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        mediaDevice.unmount();
        mediaDevice.unlock();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map restoreDataFromDisk(String filename) throws HException {
        Trace.trace(TRACE_MASKT, "SaveRestoreUtil.restoreDataFromDisk()");
        Map map = null;
        MediaServices mediaServices = null;
        MediaDeviceIdentifier mediaDeviceIdentifier = null;
        MediaDevice mediaDevice = null;
        try {
            try {
                mediaServices = MediaServices.getMediaServices();
                Trace.trace(TRACE_MASKF, "got media services");
                mediaDeviceIdentifier = mediaServices.queryMediaDevicePath(filename);
                Trace.trace(TRACE_MASKF, "got media deviceIdentifier: " + mediaDeviceIdentifier);
                if (mediaDeviceIdentifier != null) {
                    Trace.trace(TRACE_MASKF, "requesting media lock");
                    mediaDevice = mediaServices.requestLock(new LocalizableText("SaveRestoreUtil"), mediaDeviceIdentifier);
                    Trace.trace(TRACE_MASKF, "mounting");
                    mediaDevice.mountReadOnly();
                }
                Trace.trace(TRACE_MASKF, "reading in file");
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(new File(filename)));
                Object readObject = ois.readObject();
                ois.close();
                if (!(readObject instanceof Map)) {
                    throw new HException("Object read from disk was not a map!");
                }
                map = (Map)readObject;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                }
                Object var10_13 = null;
                if (mediaDevice == null) return map;
            }
            catch (MediaDeviceLockException mdle) {
                Trace.trace(TRACE_MASKF, "MediaDeviceLockException");
                Trace.trace(TRACE_MASKF, mdle);
                throw new HException(mdle);
            }
            catch (MediaDeviceException mde) {
                Trace.trace(TRACE_MASKF, "MediaDeviceException");
                Trace.trace(TRACE_MASKF, mde);
                throw new HException(mde);
            }
            catch (IOException ioe) {
                throw new HException(ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new HException(cnfe);
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (mediaDevice == null) throw throwable;
            try {
                mediaDevice.unmount();
                mediaDevice.unlock();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        mediaDevice.unmount();
        mediaDevice.unlock();
        return map;
    }

    int validFileName(String fileName, boolean writeMode) {
        int returnval = 0;
        File f = new File(fileName);
        if (writeMode) {
            if (f.exists()) {
                if (f.canWrite()) {
                    return 3;
                }
                return 5;
            }
            try {
                f.createNewFile();
            }
            catch (IOException ioe) {
                Trace.trace(TRACE_MASKT, "Save/Restore Customizable Data Bean --\nException with test while trying to create filename [" + fileName + "]");
                return 5;
            }
            if (f.canWrite()) {
                returnval = 2;
            }
        } else {
            if (f.exists() && f.canRead()) {
                return 1;
            }
            return 4;
        }
        f.delete();
        return returnval;
    }

    boolean restoreItemsWarningCheck(String[] selectedStrings) {
        Trace.trace(TRACE_MASKT, "-> SaveRestoreUtil.restoreItemsWarningCheck()");
        boolean found = false;
        if (dataRepApp.isDataRepEnabled()) {
            for (int j = 0; j < selectedStrings.length; ++j) {
                int underscore = selectedStrings[j].indexOf(95);
                int impl = Integer.parseInt(selectedStrings[j].substring(0, underscore));
                int item = Integer.parseInt(selectedStrings[j].substring(underscore + 1));
                String customDataKey = ((CustomizableData[])this.saveableItems.get(impl))[item].getCustomDataKey();
                if (!dataRepApp.isCustomDataConfigured(customDataKey)) continue;
                found = true;
                j = selectedStrings.length;
            }
        }
        Trace.trace(TRACE_MASKT, "<- SaveRestoreUtil.restoreItemsWarningCheck(" + found + ")");
        return found;
    }
}

